function cb_m52 
% Menu 52
% Display Z and Za

  global f
  global sR0                 
  global isR0Variable       
  global sC0           
  global sLs          
  global sRs 
  global sfontsize 
  global persParamsDir   
  global puzFname
  global puDataDir 
  global relmin
  global hdt
  global m52
  
  isCancelMeasurement = true; 
  
  capt = get(m52,'label');
  
  pupFname=strrep(puzFname,'.puz','.pup');
  
  [fname, fpath, fltidx] = uigetfile({'*.pup','Open a PUP - file'}, ...
                           capt,strcat(puDataDir,pupFname));
 
  if fltidx > 0
   
    cancelMeasurement; 
    
    pupFname=fname;
    puzFname=strrep(pupFname,'.pup','.puz');
    puDataDir=fpath;
    sn = strcat(persParamsDir,'puDirFname.mat');
    save('-mat',sn,'puDataDir', 'puzFname');  
    
    loadname=strcat(puDataDir,puzFname);
    loadname2=strcat(puDataDir,pupFname);
    planename=strrep(puzFname,'.puz','');
    titlename=[planename,': (Z, Za) / \Omega'];
    
    load(loadname,'-mat');
    load(loadname2,'-mat');   
    
    ncoils = 1;
    if Ls(2) >0   
      ncoils =2;
      if Ls(3) > 0
        ncoils = 3;
      end  
    end
    
    s=j*2*pi*f;
    Zc=0;
    for i=1:ncoils
      Zsc = s*Ls(i)./ (1 + s*Ls(i)/Rs(i));
      Zc=Zc+Zsc;   
    end    
    Zs=R0+Zc;
    Zp=1./(s*C0);
    Za=Zs.*Zp./(Zs+Zp);
    
    L=20*log10(abs(Z));    
    P=180/pi*angle(Z); 
    
    La=20*log10(abs(Za));    
    Pa=180/pi*angle(Za);     
    
    if ishandle(hdt) 
        delete(hdt) 
    end;
    
    fa=f(1);
    fb=f(end);
      
    subplot(2,1,1)
    
    semilogx(f,L,'b',f,La,'r')
    axis([fa fb 55 125])
    grid
    title(titlename);
    xlabel('Frequency / Hz')
    ylabel('Gain / dB')
    ha1=gca;
    
    ht1=text(25,118,['R0 = ',num2str(R0/1e3,4'),' k\Omega']);
    ht2=text(120,118,['C0 = ',num2str(C0/1e-12,4'),' pF']);
    
    ht3=text(25,108,['L1 = ',num2str(Ls(1),4'),' H']);
    ht4=text(120,108,['R1 = ',num2str(Rs(1)/1e3,4),' k\Omega']);
    
    if  Ls(2)~=0
      ht5=text(25,98,['L2 = ',num2str(Ls(2),4'),' H']);
      ht6=text(120,98,['R2 = ',num2str(Rs(2)/1e3,4),' k\Omega']);
    end 
    if  Ls(3)~=0
      ht7=text(25,88,['L3 = ',num2str(Ls(3),4'),' H']);
      ht8=text(120,88,['R3 = ',num2str(Rs(3)/1e3,4),' k\Omega']);
    end
    
    ht9=text(25,62,['RMS Error = ',num2str(rmse,2),' dB']);
    
    subplot(2,1,2) 
    
    semilogx(f,P,'b',f,Pa,'r')
    axis([fa fb -100 100]);
    grid
    xlabel('Frequency / Hz')
    ylabel('Phase / degree') 
    ha2=gca;
    
    set(ha1, 'fontsize',sfontsize);   
    set(ha2, 'fontsize',sfontsize); 
    set(ht1,'fontsize', sfontsize); 
    set(ht2,'fontsize', sfontsize); 
    set(ht3, 'fontsize', sfontsize); 
    set(ht4,'fontsize', sfontsize); 
    if  Ls(2)~=0
      set(ht5,'fontsize', sfontsize);
      set(ht6,'fontsize', sfontsize);  
    end
    if  Ls(3)~=0
      set(ht7,'fontsize', sfontsize); 
      set(ht8, 'fontsize', sfontsize);
    end    
    set(ht9,'fontsize', sfontsize); 
    
  end
  
end